from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract


class CheckManyEarthlikes(CheckerSystemAbstract):
    CONFIG_NAME_EARTHLIKE_COUNT = "earthlike_count"

    def check(self, systemState):
        super().check(systemState)

        criteriaCount = int(self.getConfigValue(self.CONFIG_NAME_EARTHLIKE_COUNT))

        system = self.systemState.getSystem()
        earthlikeCount = 0
        for bodyId in system:
            body = system[bodyId]
            if body.getType() == 'Earthlike body':
                earthlikeCount += 1

        if earthlikeCount > criteriaCount:
            self.addMessage(
                self.translate("checker_many_earthlikes").format(str(earthlikeCount)),
                body.getSystemName()
            )

        return self.results

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_EARTHLIKE_COUNT,
                'value': self.getConfigValue(self.CONFIG_NAME_EARTHLIKE_COUNT)
            }
        ]
