from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract


class CheckManyAmmoniaWorlds(CheckerSystemAbstract):
    CONFIG_NAME_AMMONIAWORLD_COUNT = "ammoniaworld_count"

    def check(self, systemState):
        super().check(systemState)

        criteriaCount = int(self.getConfigValue(self.CONFIG_NAME_AMMONIAWORLD_COUNT))

        system = self.systemState.getSystem()
        count = 0
        for bodyId in system:
            body = system[bodyId]
            if body.getType() == 'Ammonia world':
                count += 1

        if count > criteriaCount:
            self.addMessage(
                self.translate("checker_many_ammonia_worlds").format(str(count)),
                body.getSystemName()
            )

        return self.results

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_AMMONIAWORLD_COUNT,
                'value': self.getConfigValue(self.CONFIG_NAME_AMMONIAWORLD_COUNT)
            }
        ]
