from package.Observer.CheckerAbstract import CheckerAbstract
from package.Helper.Converter import Converter
from package.Journal.Events.Planet import Planet


class CheckHighGravity(CheckerAbstract):
    CONFIG_NAME_GRAVITY_THRESHOLD = "gravity_threshold"

    def check(self, body):
        super().check(body)

        gravityTreshold = float(self.getConfigValue(self.CONFIG_NAME_GRAVITY_THRESHOLD))

        if not isinstance(body, Planet):
            return self.result

        landable = body.isLandable()
        gravity = Converter.getGravity(body.getGravity())

        if landable and gravity >= gravityTreshold:
            self.result.found = True
            self.result.body = body.getName()
            self.result.message = self.translate("checker_high_gravity").format(body.getGravityAsString())

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'float',
                'name': self.CONFIG_NAME_GRAVITY_THRESHOLD,
                'value': self.getConfigValue(self.CONFIG_NAME_GRAVITY_THRESHOLD)
            }
        ]
