from package.Observer.CheckerAbstract import CheckerAbstract
from package.Helper.Apsis import Apsis


class CheckHighEccentricity(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    CONFIG_NAME_ECCENTRICITY = "eccentricity_threshold"
    CRITERIA_ECCENTRICITY = 0.9

    def check(self, body):
        super().check(body)

        eccentricityTreshold = float(self.getConfigValue(self.CONFIG_NAME_ECCENTRICITY))

        ecc = body.getEccentricity()
        sma = body.getSemiMajorAxis()

        perihelion = Apsis.calculatePerihelion(sma, ecc)
        aphelion = Apsis.calculateAphelion(sma, ecc)

        if (ecc > eccentricityTreshold):
            self.result.found = True
            self.result.body = body.getName()
            self.result.message = self.translate("checker_eccentric_orbit").format(
                body.getEccentricityAsString(6),
                str(perihelion),
                str(aphelion)
            )

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'float',
                'name': self.CONFIG_NAME_ECCENTRICITY,
                'value': self.getConfigValue(self.CONFIG_NAME_ECCENTRICITY)
            }
        ]
