from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Elite.PlanetTypes import PlanetTypes


class CheckHeliumRichSystem(CheckerSystemAbstract):
    CONFIG_NAME_HELIUM_THRESHOLD = "helium_threshold"

    def check(self, systemState):
        super().check(systemState)

        heliumTreshold = float(self.getConfigValue(self.CONFIG_NAME_HELIUM_THRESHOLD))

        system = self.systemState.getSystem()
        for i in system:
            body = system[i]
            planetClass = body.getType()

            if planetClass in self.getPlanetsToCheck():
                atmosphere = body.getAtmosphereComposition()
                for content in atmosphere:
                    if content.getName() == "Helium" and content.getPercent() > heliumTreshold:
                        message = self.translate("checker_helium_rich_system").format(
                            content.getPercentAsString()
                        )

                        self.addMessage(
                            message,
                            body.getName(),
                        )

        return self.results

    def getPlanetsToCheck(self):
        return [
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_I'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_II'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_III'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_IV'],
            PlanetTypes.TYPES['TYPE_SUDARSKY_CLASS_V'],
            PlanetTypes.TYPES['TYPE_GAS_GIANT_WATER_LIFE'],
            PlanetTypes.TYPES['TYPE_GAS_GIANT_AMMONIA_LIFE'],
        ]

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'float',
                'name': self.CONFIG_NAME_HELIUM_THRESHOLD,
                'value': self.getConfigValue(self.CONFIG_NAME_HELIUM_THRESHOLD)
            }
        ]
