from package.Observer.CheckerAbstract import CheckerAbstract


class CheckFastOrbit(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    CONFIG_NAME_ORBITAL_PERIOD = "orbital_period"

    def check(self, body):
        super().check(body)

        citeriaOrbitalPeriod = int(self.getConfigValue(self.CONFIG_NAME_ORBITAL_PERIOD))

        orbitalPeriod = body.getOrbitalPeriod()
        if orbitalPeriod > 0 and orbitalPeriod < citeriaOrbitalPeriod:
            self.result.found = True
            self.result.body = body.getName()
            self.result.message = self.translate("checker_fast_orbit").format(body.getOrbitalPeriodAsString())

        return self.result

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_ORBITAL_PERIOD,
                'value': self.getConfigValue(self.CONFIG_NAME_ORBITAL_PERIOD)
            }
        ]
