from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract


class CheckEarthlikeWithWaterWorldMoon(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        system = self.systemState.getSystem()
        for bodyId in system:
            body = system[bodyId]
            if body.getType() == 'Water world':
                parentId = body.getParentPlanet()
                if (parentId is not None) and (parentId in system):
                    parent = system[parentId]
                    if parent.getType() == "Earthlike body":
                        self.addMessage(
                            self.translate("checker_earthlike_with_water_moon"),
                            body.getName()
                        )

        return self.results
