from package.Observer.CheckerAbstract import CheckerAbstract


class CheckEarthlikeIceRing(CheckerAbstract):
    # mandatory definition: this is a body checker
    CHECKER_TYPE = CheckerAbstract.CHECKER_TYPE_BODY

    def check(self, body):
        super().check(body)

        if body.getType() == 'Earthlike body' and body.hasRings():
            for ring in body.getRings():
                if ring.getType() == "eRingClass_Icy":
                    self.result.found = True
                    self.result.body = body.getName()
                    self.result.message = self.translate("checker_earthlike_ice_ring")

        return self.result
