from decimal import *
import locale
from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Journal.Events.Planet import Planet
from package.Elite.Enum import LIGHT_SECOND_M


class CheckCloseOrbit(CheckerSystemAbstract):
    CONFIG_NAME_TIMES_BODY_RADIUS = "times_body_radius"

    def check(self, systemState):
        super().check(systemState)

        criteriaTimes = int(self.getConfigValue(self.CONFIG_NAME_TIMES_BODY_RADIUS))

        system = self.systemState.getSystem()
        for bodyId in system:
            body = system[bodyId]
            parentId = body.getParentId()

            if parentId is not None and parentId in system:
                parentObject = system[parentId]
                parentRadius = parentObject.getRadius()
                bodyAxis = body.getSemiMajorAxis()
                bodyRadius = body.getRadius()

                if (parentRadius is None) or (bodyAxis is None):
                    return self.results

                if (parentRadius * criteriaTimes) > bodyAxis:
                    distance = bodyAxis - bodyRadius - parentRadius
                    distance = distance / 1000
                    unitTranslation = self.translate("kilometers_abbr", "Systemview")

                    if distance > (LIGHT_SECOND_M / 10000):
                        distance = distance / Decimal((LIGHT_SECOND_M / 1000))
                        unitTranslation = self.translate("lightsecond_abbr", "Systemview" )

                    # is planet and landable?
                    landableTxt = ""
                    if isinstance(body, Planet) and body.isLandable():
                        landableTxt = "(" + self.translate("landable") + ")"

                    message = self.translate("checker_close_orbit").format(
                        locale.format_string('%.2f', distance, True),
                        unitTranslation,
                        body.getName(),
                        landableTxt
                    )

                    self.addMessage(
                        message,
                        body.getName()
                    )

        return self.results

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'int',
                'name': self.CONFIG_NAME_TIMES_BODY_RADIUS,
                'value': self.getConfigValue(self.CONFIG_NAME_TIMES_BODY_RADIUS)
            }
        ]
