from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract
from package.Journal.Events.Planet import Planet


class CheckCloseBinary(CheckerSystemAbstract):
    CONFIG_NAME_RADIUS_AXIS_FACTOR = "radius_axis_factor"

    def check(self, systemState):
        super().check(systemState)

        criteriaFactor = float(self.getConfigValue(self.CONFIG_NAME_RADIUS_AXIS_FACTOR))

        system = self.systemState.getSystem()
        for bodyId in system:
            body = system[bodyId]
            radius = body.getRadius()
            axis = body.getSemiMajorAxis()

            if axis == 0 or (radius / axis) < criteriaFactor:
                continue

            # only check on pair of a binary
            if body.getName() in self.alreadyScanned:
                continue

            partners = self.getBinaryPartner(body)
            if len(partners) == 1:
                pradius = partners[0].getRadius()
                paxis = partners[0].getSemiMajorAxis()

                if (pradius / paxis) > criteriaFactor:
                    landableTxt = landableTxt2 = ""
                    if isinstance(body, Planet) and body.isLandable():
                        landableTxt = "(" + self.translate("landable") + ")"

                    if isinstance(partners[0], Planet) and partners[0].isLandable():
                        landableTxt2 = "(" + self.translate("landable") + ")"

                    self.addMessage(
                        self.translate("checker_close_binary").format(
                            body.getName(),
                            landableTxt,
                            partners[0].getName(),
                            landableTxt2
                        ),
                        body.getName()
                    )

                    self.alreadyScanned.append(body.getName())
                    self.alreadyScanned.append(partners[0].getName())

        return self.results

    def getBinaryPartner(self, body):
        partners = []

        bodyId = body.getBodyId()
        bodyNullParent = body.getNullParent()

        if bodyNullParent is None:
            return []

        system = self.systemState.getSystem()

        for ref in system:
            refBody = system[ref]
            refParentId = refBody.getFirstParent()
            refBodyId = refBody.getBodyId()

            if refParentId is None:
                continue

            if refParentId == bodyNullParent and bodyId != refBodyId:
                partners.append(system[ref])

        return partners

    def hasConfigValues(self) -> bool:
        return True

    def getConfigFields(self) -> list:
        """
        Returns the available configuration fields for the checker. used in the UI to display the form fields.
        :return: dict
        """
        return [
            {
                'type': 'float',
                'name': self.CONFIG_NAME_RADIUS_AXIS_FACTOR,
                'value': self.getConfigValue(self.CONFIG_NAME_RADIUS_AXIS_FACTOR)
            }
        ]
