from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract


class CheckClassVWithAmmoniaMoon(CheckerSystemAbstract):
    def check(self, systemState):
        super().check(systemState)

        system = self.systemState.getSystem()
        for bodyId in system:
            body = system[bodyId]
            if body.getType() == 'Ammonia world':
                parentId = body.getParentPlanet()
                if (parentId is not None) and (parentId in system):
                    parent = system[parentId]
                    parentClass = parent.getType()
                    if 'class V' in parentClass:
                        self.addMessage(
                            self.translate("checker_class_v_ammonia_moon"),
                            body.getName()
                        )

        return self.results
