from package.Observer.CheckerSystemAbstract import CheckerSystemAbstract


class CheckBodyInsideRing(CheckerSystemAbstract):

    def check(self, systemState):
        super().check(systemState)

        system = self.systemState.getSystem()
        for bodyId in system:
            body = system[bodyId]
            parentId = body.getParentId()

            if parentId is not None and parentId in system:
                parentObject = system[parentId]

                if not parentObject.hasRings():
                    continue

                rings = parentObject.getRings()
                bodySemiMajorAxis = body.getSemiMajorAxis()

                maxRing = len(rings)
                maxRing -= 1

                outerRing = rings[maxRing]
                if "Belt" not in outerRing.getName() and outerRing.getOuterRadius() > bodySemiMajorAxis:
                    self.addMessage(
                        self.translate("checker_shepherd_moon"),
                        body.getName()
                    )

        return self.results
