import importlib
import traceback
import sys
import logging
from package.Config.ConfigManager import ConfigManager
from package.Observer.CheckerAbstract import CheckerAbstract
from package.Observer.ObserverMessage import ObserverMessage

log = logging.getLogger(__name__)

class Analyzer:
    _instance = None

    def __init__(self):
        self.bodyChecker = []
        self.systemChecker = []
        #self.checkMessages = []
        self.initChecker()

        Analyzer._instance = self

    @staticmethod
    def getInstance():
        """ Fake singleton for now """
        if Analyzer._instance == None:
            Analyzer()
        return Analyzer._instance

    def initChecker(self):
        packageNameBase = "package.Observer.Checker."
        activeChecker = ConfigManager.getActiveChecker()

        for checker in activeChecker:
            packageName = packageNameBase + checker["name"]
            checkerModule = importlib.import_module(packageName)
            classname = getattr(checkerModule, checker["name"])
            checkerInstance = classname()
            if checkerInstance.CHECKER_TYPE == CheckerAbstract.CHECKER_TYPE_BODY:
                self.bodyChecker.append(checkerInstance)

            if checkerInstance.CHECKER_TYPE == CheckerAbstract.CHECKER_TYPE_SYSTEM:
                self.systemChecker.append(checkerInstance)

    def analyzeBody(self, body):
        checkMessages = []
        for check in self.bodyChecker:
            try:
                checkResult = check.check(body)
                checkMessages.append(
                    ObserverMessage.createCheckMessage(checkResult)
                )
            except:
                message = str(sys.exc_info()[0])
                message += traceback.format_exc()

                log.critical(message)

                checkMessages.append(
                    ObserverMessage.createErrorMessage(message)
                )

        return checkMessages

    def analyzeSystem(self, system):
        checkMessages = []
        for systemChecker in self.systemChecker:
            try:
                checkResult = systemChecker.check(system)
                checkMessages = checkMessages + checkResult
            except:
                message = str(sys.exc_info()[0])
                message += traceback.format_exc()

                log.critical(message)

                checkMessages.append(
                    ObserverMessage.createErrorMessage(message)
                )

        return checkMessages
