import platform
from package.Config.ConfigManager import ConfigManager
if platform.system() == "Linux":
    from package.Notification.Desktop.LinuxNotifier import LinuxNotifier as Notifier
else:
    from package.Notification.Desktop.WindowsNotifier import WindowsNotifier as Notifier


class DesktopNotifier:
    def __init__(self):
        self.notifier = Notifier()

    def emit(self, message):
        if ConfigManager.getConfigValue("desktop_notifications") == "1":
            self.notifier.emitMessage(message)
