from package.Helper.ClassLoader import ClassLoader
from package.Journal.Events.Star import Star
from package.Journal.Events.Planet import Planet
from package.Config.ConfigManager import ConfigManager


class JournalFactory:
    @staticmethod
    def getEntityFromJournal(data):
        if "event" not in data:
            return None

        event = data["event"]

        # if it's a scan event, create the object directly
        if "StarType" in data:
            obj = Star()
            obj.setTemperatureFormat(ConfigManager.getConfigValue("temperature_format"))
        elif 'PlanetClass' in data:
            obj = Planet()
            obj.setTemperatureFormat(ConfigManager.getConfigValue("temperature_format"))
        else:
            # try to autoload the event class if present
            packageBase = "package.Journal.Events."
            packageName = packageBase + event

            obj = ClassLoader.getClass(packageName, event)

        if obj:
            obj.initFromJournal(data)

        return obj
