from PyQt5.QtCore import QCoreApplication
from .ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage


class ShutdownEvent(ObserverAbstract):
    listenToEvent = "Shutdown"

    def notify(self, event):
        if self.system.getCount() > 0:
            self.eventSignal.emit(
                ObserverMessage.createStatusMessage(
                    QCoreApplication.translate("Events", "Analyzing remaining {0} bodies because shutdown").format(str(self.system.getCount()))
                )
            )

            # analyze system
            results = self.analyzer.analyzeSystem(self.system)

            # emit messages from analizer. should be done in analyzer in the future
            if len(results) > 0:
                for message in results:
                    self.eventSignal.emit(message)

        self.system.resetSystem()
        self.system.setSystemComplete(False)
