import locale
from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage
from package.Config.ConfigManager import ConfigManager
from package.Database.DbFactory import DbFactory
from package.Observer.CalculationHandler import CalculationHandler


class SellOrganicDataEvent(ObserverAbstract):
    listenToEvent = "SellOrganicData"

    def notify(self, event):
        overallCredits = locale.format_string('%.2f', event.getOverallCredits(), True)

        self.eventSignal.emit(
            ObserverMessage.createStatusMessage(
                QCoreApplication.translate("Events", "sell_organic_data").format(
                    str(overallCredits))
            )
        )

        # check if credit count needs to be reseted?
        if ConfigManager.getConfigValue("automatic_credit_reset") == "1":
            db = DbFactory.getDatabase()
            db.delete('bio_calculation')

            calc = CalculationHandler.getInstance(db)
            calc.resetBioScanValues()

            self.eventSignal.emit(
                ObserverMessage.createBioCalculationMessage(0, 0)
            )

            self.eventSignal.emit(
                ObserverMessage.createStatusMessage(
                    QCoreApplication.translate("Events", "automatic_bio_credit_reset")
                )
            )
