from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Config.ConfigManager import ConfigManager
from package.Observer.ObserverMessage import ObserverMessage
from package.Helper.ScreenshotHandler import ScreenshotHandler


class ScreenshotEvent(ObserverAbstract):
    listenToEvent = "Screenshot"

    def notify(self, event):
        if self.isActive():
            handler = ScreenshotHandler()
            handler.processScreenshot(event)
            self.eventSignal.emit(
                ObserverMessage.createStatusMessage(QCoreApplication.translate("Events", "Converting Screenshot"))
            )

    def isActive(self):
        active = ConfigManager.getConfigValue("screenshot_conversion")
        sourceDir = ConfigManager.getConfigValue("screenshot_source_dir")
        destinationDir = ConfigManager.getConfigValue("screenshot_destination_dir")

        if (active == "0") or (sourceDir == "") or (destinationDir == ""):
            return False

        return True
