from PyQt5.QtCore import QCoreApplication
import locale
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage
from package.Observer.SessionStatisticHandler import SessionStatisticHandler
from package.Calculator.OrganicsCalculator import OrganicsCalculator
from package.Database.DbFactory import DbFactory
from package.Observer.CalculationHandler import CalculationHandler
from package.Elite.Organics import SCAN_TYPE_LOG
from package.Elite.Organics import SCAN_TYPE_ANALYSE


class ScanOrganicEvent(ObserverAbstract):
    listenToEvent = "ScanOrganic"

    def __init__(self):
        super().__init__()

    def notify(self, event):
        scanType = event.getScanType()
        organicType = event.getVariantLocalised()

        # add to session statistic if it's a analyse type
        if scanType == SCAN_TYPE_ANALYSE:
            SessionStatisticHandler.getInstance().addOrganicScan()
            self.doCalculation(event)

        credits = 0
        if scanType == SCAN_TYPE_LOG:
            credits = OrganicsCalculator.getCreditsForOrganics(event.getSpecies().lower())

        creditsText = ""
        if credits > 0:
            creditsText = QCoreApplication.translate("Events", "observer_scan_organic_value").format(
                locale.format_string('%.0f', credits, True)
            )

        # push message
        message = QCoreApplication.translate("Events", "observer_scan_organic").format(scanType, organicType, creditsText)
        self.eventSignal.emit(
            ObserverMessage.createStatusMessage(message)
        )

    def doCalculation(self, event):
        db = DbFactory.getDatabase()
        CalculationHandler.getInstance(db).handleBioCalculation(event.getSpecies())

        self.eventSignal.emit(
            ObserverMessage.createBioCalculationMessage(
                CalculationHandler.getInstance(db).getBioSessionValue(),
                CalculationHandler.getInstance(db).getBioTotalValue()
            )
        )
