from .ObserverAbstract import ObserverAbstract
from package.Database.DbFactory import DbFactory
from package.Observer.ObserverMessage import ObserverMessage
from package.Observer.CalculationHandler import CalculationHandler
from package.Observer.SessionStatisticHandler import SessionStatisticHandler


class SAAScanCompleteEvent(ObserverAbstract):
    listenToEvent = "SAAScanComplete"

    def notify(self, event):
        bodyName = event.getBodyName()
        number = self.getBodyNumber(bodyName, self.system.getCurrentSystem())

        if self.system.isSetObjectWorthScanning(number):
            self.system.updateObjectWorthScanning(number, True)
            self.eventSignal.emit(ObserverMessage.createWorthScanningMessage(self.system.getObjectsWorthScanning()))

        # calculate values
        self.doCalculation(event)

        # add statistic data
        SessionStatisticHandler.getInstance().addDetailScan()

    def doCalculation(self, event):
        db = DbFactory.getDatabase()
        CalculationHandler.getInstance(db).handleDetailCalculation(event)

        self.eventSignal.emit(
            ObserverMessage.createCalculationMessage(
                CalculationHandler.getInstance(db).getSessionValue(),
                CalculationHandler.getInstance(db).getTotalValue()
            )
        )
