import locale
from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage
from package.Config.ConfigManager import ConfigManager
from package.Database.DbFactory import DbFactory
from package.Observer.CalculationHandler import CalculationHandler


class MultiSellExplorationDataEvent(ObserverAbstract):
    listenToEvent = "MultiSellExplorationData"

    def notify(self, event):
        self.system.addExplorationAmount(event.getTotalEarnings())

        overallCredits = locale.format_string('%.2f', self.system.getExplorationAmount(), True)

        self.eventSignal.emit(
            ObserverMessage.createStatusMessage(
                QCoreApplication.translate("Events", "multisell_exploration_data").format(
                    str(overallCredits))
            )
        )

        # check if credit count needs to be reseted?
        if ConfigManager.getConfigValue("automatic_credit_reset") == "1":
            db = DbFactory.getDatabase()
            db.delete('calculation')

            calc = CalculationHandler.getInstance(db)
            calc.resetBodyScanValues()

            self.eventSignal.emit(
                ObserverMessage.createCalculationMessage(0, 0)
            )

            self.eventSignal.emit(
                ObserverMessage.createStatusMessage(
                    QCoreApplication.translate("Events", "automatic_exploration_credit_reset")
                )
            )
