from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage
from package.Observer.CheckResult import CheckResult


class FSSSignalDiscoveredEvent(ObserverAbstract):
    listenToEvent = "FSSSignalDiscovered"

    def __init__(self):
        super().__init__()

    def notify(self, event):
        if event.getSignalName() == "$Fixed_Event_Life_Cloud":
            message = QCoreApplication.translate("Events", "star_phenomena").format(event.getSignalNameLocalised())

            checkResult = CheckResult()
            checkResult.found = True
            checkResult.message = message
            checkResult.body = ''

            self.eventSignal.emit(
                ObserverMessage.createCheckMessage(checkResult)
            )
