from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage


class FSSDiscoveryScanEvent(ObserverAbstract):
    listenToEvent = "FSSDiscoveryScan"

    def notify(self, event):
        # set body count
        self.system.setBodyCount(event.getBodyCount())

        self.eventSignal.emit(
            ObserverMessage.createStatusMessage(
                QCoreApplication.translate("Events", "Discovery scan: {0} bodies and {1} non-bodies detected").format(
                    str(event.getBodyCount()), str(event.getNonBodyCount()))
            )
        )
