from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage


class FSSAllBodiesFoundEvent(ObserverAbstract):
    listenToEvent = "FSSAllBodiesFound"

    def notify(self, event):
        if self.system.getCount() >= event.getCount():
            self.system.setSystemComplete(True)

            self.eventSignal.emit(
                ObserverMessage.createStatusMessage(
                    QCoreApplication.translate("Events", "All {0} bodies scanned. analyzing system").format(str(self.system.getCount())) + "<br>"
                )
            )
            results = self.analyzer.analyzeSystem(self.system)

            if len(results) > 0:
                for message in results:
                    self.eventSignal.emit(message)

            # all bodies scanned and handles. reset system array
            self.system.resetSystem()
