from PyQt5.QtCore import QCoreApplication
from package.Journal.Handler.Observer.ObserverAbstract import ObserverAbstract
from package.Observer.ObserverMessage import ObserverMessage


class CodexEntryEvent(ObserverAbstract):
    listenToEvent = "CodexEntry"

    def __init__(self):
        super().__init__()

    def notify(self, event):
        signalTypeName = event.getNameLocalised()

        isNew = ""
        if event.isNewEntry():
            isNew = QCoreApplication.translate("Events", "new")

        message = QCoreApplication.translate("Events", "Codex Entry").format(isNew, signalTypeName)
        self.eventSignal.emit(
            ObserverMessage.createStatusMessage(message)
        )
