from package.Journal.Handler.Import.ImportAbstract import ImportAbstract
from package.Import.ImporterStar import ImporterStar
from package.Import.ImporterPlanet import ImporterPlanet
from package.Journal.Events.Star import Star
from package.Journal.Events.Planet import Planet


class ScanEvent(ImportAbstract):
    listenToEvent = "Scan"

    def __init__(self):
        super().__init__()
        self.importerStar = ImporterStar()
        self.importerPlanet = ImporterPlanet()

    def notify(self, body):
        # import star
        if isinstance(body, Star) and (self.system.getCurrentSystemAddress() is not None):
            self.importerStar.setSystemAddress(self.system.getCurrentSystemAddress())
            self.importerStar.process(body)
            self.importerStar.flush()

        # import planet
        if isinstance(body, Planet) and (self.system.getCurrentSystemAddress() is not None):
            # check if body signals are available
            bodySignalEvent = self.system.getBodySignalEvent(body.getBodySignalKey())
            self.importerPlanet.setBodySignalEvent(bodySignalEvent)

            self.importerPlanet.setSystemAddress(self.system.getCurrentSystemAddress())
            self.importerPlanet.process(body)
            self.importerPlanet.flush()

            self.system.removeBodySignalEvent(body.getBodySignalKey())
