from package.Journal.Handler.Import.ImportAbstract import ImportAbstract
from package.Import.ImporterSystem import ImporterSystem
from package.Import.ImportFlightLog import ImporterFlightLog
from package.Datareader.FlightlogReader import FlightlogReader


class LocationEvent(ImportAbstract):
    listenToEvent = "Location"

    def __init__(self):
        super().__init__()
        self.importerSystem = ImporterSystem()
        self.importerFlightLog = ImporterFlightLog()
        self.flightlogReader = FlightlogReader()

    def notify(self, event):
        if event.getBodyType() == "Planet":
            self.system.setCurrentBody(event.getBody())

        self.system.setCurrentSystemAddress(event.getSystemAddress())

        # check latest flightlog position
        # if last system address differs from current one the ship probably jumped with a carrier while the
        # commander was offline. in this case insert the new system and update flightlog
        lastSystemAddress = self.flightlogReader.getLastSystemAddress()

        if lastSystemAddress != event.getSystemAddress():
            # import system and flightlog
            self.importerSystem.process(event)
            self.importerSystem.flush()
            self.importerFlightLog.process(event)
            self.importerFlightLog.flush()
