from package.Journal.Handler.Import.ImportAbstract import ImportAbstract
from package.Import.ImporterSystem import ImporterSystem
from package.Import.ImportFlightLog import ImporterFlightLog


class FSDJumpEvent(ImportAbstract):
    listenToEvent = "FSDJump"

    def __init__(self):
        super().__init__()
        self.importerSystem = ImporterSystem()
        self.importerFlightLog = ImporterFlightLog()

    def notify(self, event):
        # init system data
        self.system.reset()
        self.system.setCurrentSystemAddress(event.getSystemAddress())

        # import system and flightlog
        self.importerSystem.process(event)
        self.importerSystem.flush()
        self.importerFlightLog.process(event)
        self.importerFlightLog.flush()
