from package.Journal.Handler.Import.ImportAbstract import ImportAbstract
from package.Import.ImporterCodex import ImporterCodex


class CodexEntryEvent(ImportAbstract):
    listenToEvent = "CodexEntry"

    def __init__(self):
        super().__init__()
        self.importerCodex = ImporterCodex()

    def notify(self, event):
        latitute = event.getLatitude()
        longitude = event.getLongitude()

        if latitute is None:
            latitute = self.system.getLatitute()

        if longitude is None:
            longitude = self.system.getLongitude()

        self.importerCodex.setCurrentBody(self.system.getCurrentBody())
        self.importerCodex.setLatitude(latitute)
        self.importerCodex.setLongitude(longitude)
        self.importerCodex.process(event)
        self.importerCodex.flush()
