from package.Journal.Events.BaseEntity import BaseEntity


class Undocked(BaseEntity):
    def __init__(self):
        super().__init__()
        self._stationName = None
        self._stationType = None
        self._marketId = None
        self._taxi = False
        self._multicrew = False

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._stationName = self.getParam(data, "StationName")
        self._stationType = self.getParam(data, "StationType")
        self._marketId = self.getParam(data, "MarketID")
        self._taxi = self.getParam(data, "Taxi")
        self._multicrew = self.getParam(data, "Multicrew")

    def isTaxi(self):
        return self._taxi

    def isMulticrew(self):
        return self._multicrew

    def getStationName(self):
        return self._stationName

    def getStationType(self):
        return self._stationType

    def getMarketId(self):
        return self._marketId

    def getBodyId(self):
        return self._bodyId

    def isOnStation(self):
        return self._onStation

    def isOnPlanet(self):
        return self._onPlanet

    def getLatitude(self):
        return self._latitude

    def getLongitude(self):
        return self._longitude
