from package.Journal.Events.BaseEntity import BaseEntity


class Touchdown(BaseEntity):
    def __init__(self):
        super().__init__()
        self._playerControlled = None
        self._taxi = None
        self._multicrew = None
        self._starSystem = None
        self._systemAddress = None
        self._body = None
        self._bodyId = None
        self._onStation = False
        self._onPlanet = False
        self._latitude = 0
        self._longitude = 0

    def initFromJournal(self, data):
        super().initFromJournal(data)
        self._playerControlled = self.getParam(data, "PlayerControlled", True)
        self._taxi = self.getParam(data, "Taxi", False)
        self._multicrew = self.getParam(data, "Multicrew", False)
        self._starSystem = self.getParam(data, "StarSystem")
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._body = self.getParam(data, "Body")
        self._bodyId = self.getParam(data, "BodyID")
        self._onStation = self.getParam(data, "OnStation", False)
        self._onPlanet = self.getParam(data, "OnPlanet", False)
        self._latitude = self.getParam(data, "Latitude")
        self._longitude = self.getParam(data, "Longitude")

    def isPlayerControlled(self):
        return self._playerControlled

    def isTaxi(self):
        return self._taxi

    def isMultiCrew(self):
        return self._multicrew

    def getStarSystem(self):
        return self._starSystem

    def getSystemAddress(self):
        return self._systemAddress

    def getBody(self):
        return self._body

    def getBodyId(self):
        return self._bodyId

    def isOnPlanet(self):
        return self._onPlanet

    def isOnStation(self):
        return self._onStation

    def getLatitude(self):
        return self._latitude

    def getLongitude(self):
        return self._longitude
