from package.Journal.Events.BaseEntity import BaseEntity


class StartJump(BaseEntity):
    def __init__(self):
        super().__init__()
        self._jumpType = None
        self._starSystem = None
        self._systemAddress = None
        self._starClass = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._jumpType = self.getParam(data, "JumpType")
        self._starSystem = self.getParam(data, "StarSystem")
        self._starClass = self.getParam(data, "StarClass")

    def getJumpType(self):
        return self._jumpType

    def getStarSystem(self):
        return self._starSystem

    def getSystemAddress(self):
        return self._systemAddress

    def getStarClass(self):
        return self._starClass
