from package.Journal.Events.BaseEntity import BaseEntity
from package.Journal.Events.BioData import BioData


class SellOrganicData(BaseEntity):
    def __init__(self):
        super().__init__()
        self._bioData = []
        self._marketId = None
        self._overallCredits = 0

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._marketId = self.getParam(data, "MarketID")
        self.initBioDataFromJournal(data)

    def initBioDataFromJournal(self, data):
        data = self.getParam(data, "BioData", [])
        for bio in data:
            bioData = BioData()
            bioData.initFromJournal(bio)
            self._bioData.append(bioData)

            temp = bioData.getValue() + bioData.getBonus()
            self._overallCredits = self._overallCredits + temp

    def getBioData(self):
        return self._bioData

    def getMarketId(self):
        return self._marketId

    def getOverallCredits(self):
        return self._overallCredits
