from package.Journal.Events.BaseEntity import BaseEntity


class Screenshot(BaseEntity):
    def __init__(self):
        super().__init__()
        self._filename = None
        self._width = 0
        self._height = 0
        self._system = None
        self._body = None

    def initFromJournal(self, data):
        super().initFromJournal(data)
        self._filename = self.getParam(data, "Filename")
        self._width = self.getParam(data, "Width")
        self._height = self.getParam(data, "Height")
        self._system = self.getParam(data, "System", '')
        self._body = self.getParam(data, "Body", '')

    def getFilename(self):
        return self._filename

    def getWidth(self):
        return self._width

    def getHeight(self):
        return self._height

    def getSystem(self):
        return self._system

    def getBody(self):
        return self._body
