from package.Journal.Events.BaseEntity import BaseEntity


class ScanOrganic(BaseEntity):
    SCAN_TYPE_LOG = "Log"
    SCAN_TYPE_ANALYSE = "Analyse"

    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._scanType = None
        self._genus = None
        self._genusLocalised = None
        self._species = None
        self._speciesLocalised = None
        self._body = None
        self._variant = None
        self._variantLocalised = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._systemAddress = self.getParam(data, "SystemAddress")
        self._scanType = self.getParam(data, "ScanType")
        self._genus = self.getParam(data, "Genus")
        self._genusLocalised = self.getParam(data, "Genus_Localised")
        self._species = self.getParam(data, "Species")
        self._speciesLocalised = self.getParam(data, "Species_Localised")
        self._variant = self.getParam(data, "Variant")
        self._variantLocalised = self.getParam(data, "Variant_Localised")
        self._body = self.getParam(data, "Body")

    def initFromDatabase(self, data):
        self._systemAddress = data['system_address']
        self._scanType = data['scan_type']
        self._genus = data['genus']
        self._genusLocalised = data['genus_localised']
        self._species = data['species']
        self._speciesLocalised = data['species_localised']
        self._variant = data['variant']
        self._variantLocalised = data['variant_localised']

    def getSystemAddress(self):
        return self._systemAddress

    def getScanType(self):
        return self._scanType

    def getGenus(self):
        return self._genus

    def getGenusLocalised(self):
        return self._genusLocalised

    def getSpecies(self):
        return self._species

    def getSpeciesLocalised(self):
        return self._speciesLocalised

    def getVariant(self):
        return self._variant

    def getVariantLocalised(self):
        return self._variantLocalised

    def getBody(self):
        return self._body
