from decimal import *
from package.Journal.Events.BaseEntity import BaseEntity


class ScanBaryCentre(BaseEntity):
    def __init__(self):
        super().__init__()
        self._starSystem = None
        self._systemAddress = None
        self._bodyId = None
        self._semiMajorAxis = None
        self._eccentricity = None
        self._inclination = None
        self._periapsis = None
        self._orbitalPeriod = None
        self._ascendingNode = None
        self._meanAnomaly = None

    def initFromJournal(self, data):
        super().initFromJournal(data)
        self._systemAddress = self.getParam(data, 'SystemAddress', '')
        self._starSystem = self.getParam(data, 'StarSystem', '')
        self._bodyId = self.getParam(data, 'BodyID', 0)
        self._semiMajorAxis = Decimal(self.getParam(data, 'SemiMajorAxis', 0))
        self._eccentricity = Decimal(self.getParam(data, 'Eccentricity', 0))
        self._inclination = Decimal(self.getParam(data, 'OrbitalInclination', 0))
        self._periapsis = Decimal(self.getParam(data, 'Periapsis', 0))
        self._orbitalPeriod = Decimal(self.getParam(data, 'OrbitalPeriod', 0))
        self._ascendingNode = Decimal(self.getParam(data, 'AscendingNode', 0))
        self._meanAnomaly = Decimal(self.getParam(data, 'MeanAnomaly', 0))

    def getSystemAddress(self):
        return self._systemAddress

    def getStarSystem(self):
        return self._starSystem

    def getBodyId(self):
        return self._bodyId

    def getSemiMajorAxis(self):
        return self._semiMajorAxis

    def getEccentricity(self):
        return self._eccentricity

    def getInclination(self):
        return self._inclination

    def getPeriapsis(self):
        return self._periapsis

    def getOrbitalPeriod(self):
        return self._orbitalPeriod

    def getAscendingNode(self):
        return self._ascendingNode

    def getMeanAnomaly(self):
        return self._meanAnomaly
