class SSASignal:
    DB_TYPE_GEO = "GEO"
    DB_TYPE_BIO = "BIO"
    DB_TYPE_MISC = "MISC"
    JOURNAL_TYPE_BIO = "$SAA_SignalType_Biological;"
    JOURNAL_TYPE_GEO = "$SAA_SignalType_Geological;"

    def __init__(self):
        self._type = ''
        self._typeLocalised = ''
        self._count = 0
        self.internalId = None

    def initFromJournal(self, data):
        self._type = data['Type']
        self._count = data['Count']

        if 'Type_Localised' in data:
            self._typeLocalised = data['Type_Localised']

    def initFromDatabase(self, data):
        self._type = data['type']
        self._typeLocalised = data['type_localised']
        self._count = data['amount']
        self.internalId = data['id']

    def getType(self):
        return self._type

    def getTypeLocalised(self):
        return self._typeLocalised

    def getCount(self):
        return self._count

    def getDbType(self):
        type = None
        if self._type == self.JOURNAL_TYPE_BIO:
            type = self.DB_TYPE_BIO
        elif self._type == self.JOURNAL_TYPE_GEO:
            type = self.DB_TYPE_GEO

        return type
