from package.Journal.Events.BaseEntity import BaseEntity


class SAAScanComplete(BaseEntity):
    def __init__(self):
        super().__init__()
        self._bodyName = None
        self._bodyId = None
        self._systemAddress = None
        self._probesUsed = None
        self._efficiencyTarget = None

    def initFromJournal(self, data):
        super().initFromJournal(data)
        self._bodyName = self.getParam(data, "BodyName")
        self._bodyId = self.getParam(data, "BodyID")
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._probesUsed = self.getParam(data, "ProbesUsed")
        self._efficiencyTarget = self.getParam(data, "EfficiencyTarget")

    def getSystemAddress(self):
        return self._systemAddress

    def getBodyName(self):
        return self._bodyName

    def getBodyId(self):
        return self._bodyId

    def getProbesUsed(self):
        return self._probesUsed

    def getEfficiencyTarget(self):
        return self._efficiencyTarget
