from decimal import *
from typing import List
import locale
from PyQt5.QtCore import QCoreApplication
from package.Journal.Events.BaseEntity import BaseEntity
from package.Journal.Events.SSASignal import SSASignal


class Ring(BaseEntity):
    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._name = None
        self._type = None
        self._mass = None
        self._innerRadius = None
        self._outerRadius = None
        self.internalId = None
        self.ssaSignals = []

    def initFromJournal(self, data):
        self._name = self.getParam(data, 'Name', '')
        self._type = self.getParam(data, 'RingClass', '')
        self._mass = Decimal(self.getParam(data, 'MassMT', 0))
        self._innerRadius = Decimal(self.getParam(data, 'InnerRad', 0))
        self._outerRadius = Decimal(self.getParam(data, 'OuterRad', 0))

    def initFromDatabase(self, data):
        if data is not None:
            self._systemAddress = data['system_address']
            self._name = data['name']
            self._type = data['ring_class']
            self._mass = Decimal(data['mass'])
            self._innerRadius = Decimal(data['inner_rad'])
            self._outerRadius = Decimal(data['outer_rad'])
            self.internalId = data['id']

    def getRingWidth(self):
        return self.getOuterRadius() - self.getInnerRadius()

    def getRingWidthAsString(self):
        width = (self.getOuterRadius() - self.getInnerRadius()) / 1000
        width2 = locale.format_string('%.2f', width, True)

        return width2 + " " + QCoreApplication.translate("Systemview", "kilometers_abbr")

    # simple getters

    def addSsaSignal(self, ssa: SSASignal):
        self.ssaSignals.append(ssa)

    def getSsaSignales(self) -> List[SSASignal]:
        """
        Returns all rings hotspots.
        Data is only available whenn creating planet object in the service
        :return: List[SSASignal]
        """
        return self.ssaSignals

    def getSystemAddress(self):
        return self._systemAddress

    def getName(self):
        return self._name

    def getType(self):
        return self._type

    def getMass(self):
        return self._mass

    def getInnerRadius(self):
        return self._innerRadius

    def getInnerRadiusAsString(self):
        rad = self.getInnerRadius() / 1000
        return locale.format_string(
            '%.2f', rad, True
        ) + " " + QCoreApplication.translate("Systemview", "kilometers_abbr")

    def getOuterRadius(self):
        return self._outerRadius

    def getOuterRadiusAsString(self):
        rad = self.getOuterRadius() / 1000
        return locale.format_string(
            '%.2f', rad, True
        ) + " " + QCoreApplication.translate("Systemview", "kilometers_abbr")

    def getInternalId(self) -> int:
        return self.internalId
