from package.Journal.Events.BaseEntity import BaseEntity


class MultiSellExplorationData(BaseEntity):
    def __init__(self):
        super().__init__()
        self._discovered = []
        self._baseValue = None
        self._bonus = None
        self._totalEarnings = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._discovered = self.getParam(data, "Discovered")
        self._baseValue = self.getParam(data, "BaseValue")
        self._bonus = self.getParam(data, "Bonus")
        self._totalEarnings = self.getParam(data, "TotalEarnings")

    def getTotalEarnings(self):
        return self._totalEarnings

    def getBaseValue(self):
        return self._baseValue

    def getBonus(self):
        return self._bonus
