from package.Journal.Events.BaseEntity import BaseEntity


class Materials(BaseEntity):
    def __init__(self):
        super().__init__()
        self._raw = []
        self._manufactured = []
        self._encoded = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._raw = self.getParam(data, "Raw", [])
        self._manufactured = self.getParam(data, "Manufactured", [])
        self._encoded = self.getParam(data, "Encoded", [])

    def getRawMaterials(self):
        return self._raw

    def getManufacturedMaterials(self):
        return self._manufactured

    def getEncodedMaterials(self):
        return self._encoded
