import locale
from decimal import *
from package.Elite.Materials import MATERIALS


class Material:
    def __init__(self):
        self._id = None
        self._name = ''
        self._nameLocalised = ''
        self._percent = Decimal(0)

    def initFromJournal(self, data) -> None:
        self._name = data['Name']
        self._nameLocalised = self._name.capitalize()
        self._percent = Decimal(data['Percent'])
        self._id = MATERIALS[self._name]

        if "Name_Localised" in data:
            self._nameLocalised = data['Name_Localised']

    def initFromDatabase(self, data) -> None:
        self._id = data['id']
        self._name = data['name']
        self._nameLocalised = data['name_de']
        self._percent = Decimal(data['percent'])

    # simple getters
    def getName(self) -> str:
        return self._name

    def getNameLocalised(self) -> str:
        return self._nameLocalised

    def getPercent(self) -> Decimal:
        return self._percent

    def getPercentAsString(self, decimals: int = 4) -> str:
        numFormat = '%.' + str(decimals) + 'f'
        return locale.format_string(numFormat, self._percent, True) + " %"

    def getId(self) -> int:
        return self._id
