from package.Journal.Events.BaseEntity import BaseEntity


class Location(BaseEntity):
    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._distance = None
        self._docked = False
        self._taxi = False
        self._multiCrew = None
        self._starSystem = None
        self._posX = 0
        self._posY = 0
        self._posZ = 0
        self._systemAllegiance = None
        self._systemEconomy = None
        self._systemEconomyLocalised = None
        self._systemSecondEconomy = None
        self._systemSecondEconomy_Localised = None
        self._systemGovernment = None
        self._systemGovernment_Localised = None
        self._systemSecurity = None
        self._systemSecurity_Localised = None
        self._population = None
        self._body = None
        self._bodyId = None
        self._bodyType = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        pos = self.getParam(data, "StarPos")
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._distance = self.getParam(data, "DistFromStarLS")
        self._docked = self.getParam(data, "Docked", False)
        self._taxi = self.getParam(data, "Taxi")
        self._multiCrew = self.getParam(data, "Multicrew")
        self._starSystem = self.getParam(data, "StarSystem")
        self._posX = pos[0]
        self._posY = pos[2]
        self._posZ = pos[1]
        self._systemAllegiance = self.getParam(data, "SystemAllegiance")
        self._systemEconomy = self.getParam(data, "SystemEconomy")
        self._systemEconomyLocalised = self.getParam(data, "SystemEconomy_Localised")
        self._systemSecondEconomy = self.getParam(data, "SystemSecondEconomy")
        self._systemSecondEconomy_Localised = self.getParam(data, "SystemSecondEconomy_Localised")
        self._systemGovernment = self.getParam(data, "SystemGovernment")
        self._systemGovernment_Localised = self.getParam(data, "SystemGovernment_Localised")
        self._systemSecurity = self.getParam(data, "SystemSecurity")
        self._systemSecurity_Localised = self.getParam(data, "SystemSecurity_Localised")
        self._population = self.getParam(data, "Population")
        self._body = self.getParam(data, "Body")
        self._bodyId = self.getParam(data, "BodyID")
        self._bodyType = self.getParam(data, "BodyType")

    def getSystemAddress(self):
        return self._systemAddress

    def getStarSystem(self):
        return self._starSystem

    def getPosX(self):
        return self._posX

    def getPosY(self):
        return self._posY

    def getPosZ(self):
        return self._posZ

    def getPos(self):
        return [self._posX, self._posZ, self._posY]

    def getBody(self):
        return self._body

    def getBodyType(self):
        return self._bodyType
