from package.Journal.Events.BaseEntity import BaseEntity


class Liftoff(BaseEntity):
    def __init__(self):
        super().__init__()
        self._playerControlled = False
        self._taxi = False
        self._multicrew = False
        self._starSystem = None
        self._systemAddress = None
        self._body = None
        self._bodyId = None
        self._onStation = False
        self._onPlanet = False
        self._latitude = None
        self._longitude = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._playerControlled = self.getParam(data, "PlayerControlled")
        self._taxi = self.getParam(data, "Taxi")
        self._multicrew = self.getParam(data, "Multicrew")
        self._starSystem = self.getParam(data, "StarSystem")
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._body = self.getParam(data, "Body")
        self._bodyId = self.getParam(data, "BodyID")
        self._onStation = self.getParam(data, "OnStation")
        self._onPlanet = self.getParam(data, "OnPlanet")
        self._latitude = self.getParam(data, "Latitude")
        self._longitude = self.getParam(data, "Longitude")

    def isSrv(self):
        return self._srv

    def isTaxi(self):
        return self._taxi

    def isMulticrew(self):
        return self._multicrew

    def getStarSystem(self):
        return self._starSystem

    def getSystemAddress(self):
        return self._systemAddress

    def getBody(self):
        return self._body

    def getBodyId(self):
        return self._bodyId

    def isOnStation(self):
        return self._onStation

    def isOnPlanet(self):
        return self._onPlanet

    def getLatitude(self):
        return self._latitude

    def getLongitude(self):
        return self._longitude
