from package.Journal.Events.BaseEntity import BaseEntity


class FSSSignalDiscovered(BaseEntity):
    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._signalName = None
        self._signalNameLocalised = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._systemAddress = self.getParam(data, "SystemAddress")
        self._signalName = self.getParam(data, "SignalName")
        self._signalNameLocalised = self.getParam(data, "SignalName_Localised")

    def getSystemAddress(self):
        return self._systemAddress

    def getSignalName(self):
        return self._signalName

    def getSignalNameLocalised(self):
        return self._signalNameLocalised
