from package.Journal.Events.BaseEntity import BaseEntity


class FSSDiscoveryScan(BaseEntity):
    def __init__(self):
        super().__init__()
        self._progress = None
        self._bodyCount = None
        self._nonBodyCount = None
        self._systemAddress = None
        self._systemName = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._progress = self.getParam(data, "Progress")
        self._bodyCount = self.getParam(data, "BodyCount")
        self._nonBodyCount = self.getParam(data, "NonBodyCount")
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._systemName = self.getParam(data, "SystemName")

    def getSystemAddress(self):
        return self._systemAddress

    def getProgress(self):
        return self._progress

    def getBodyCount(self):
        return self._bodyCount

    def getNonBodyCount(self):
        return self._nonBodyCount

    def getSystemName(self):
        return self._systemName
