from package.Journal.Events.BaseEntity import BaseEntity
from package.Journal.Events.SSASignal import SSASignal


class FSSBodySignals(BaseEntity):
    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._bodyName = None,
        self._bodyId = None,
        self._signals = []

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._bodyName = self.getParam(data, "BodyName")
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._bodyId = self.getParam(data, "BodyID")

        self.initSignalsFromJournal(data)

    def initSignalsFromJournal(self, data):
        signals = self.getParam(data, "Signals", [])

        for signalData in signals:
            signal = SSASignal()
            signal.initFromJournal(signalData)
            self._signals.append(signal)

    def getBodyName(self):
        return self._bodyName

    def getBodyId(self):
        return self._bodyId

    def getSystemAddress(self):
        return self._systemAddress

    def getSignals(self):
        return self._signals

    def getKey(self):
        return str(self._systemAddress) + '_' + str(self._bodyId)
