from package.Journal.Events.BaseEntity import BaseEntity


class FSSAllBodiesFound(BaseEntity):
    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._systemName = None
        self._count = None

    def initFromJournal(self, data):
        super().initFromJournal(data)

        self._systemAddress = self.getParam(data, "SystemAddress")
        self._systemName = self.getParam(data, "SystemName")
        self._count = self.getParam(data, "Count")

    def getSystemAddress(self):
        return self._systemAddress

    def getSystemName(self):
        return self._systemName

    def getCount(self):
        return self._count
