from package.Journal.Events.BaseEntity import BaseEntity


class CodexEntry(BaseEntity):
    def __init__(self):
        super().__init__()
        self._systemAddress = None
        self._entryId = None
        self._name = None
        self._nameLocalised = None
        self._subCategory = None
        self._subCategoryLocalised = None
        self._category = None
        self._categoryLocalised = None
        self._region = None
        self._regionLocalised = None
        self._nearestDestination = None
        self._nearestDestinationLocalised = None
        self._system = None
        self._latitude = None
        self._longitude = None
        self._isNewEntry = False
        self._voucherAmount = None

    def initFromJournal(self, data):
        super().initFromJournal(data)
        self._systemAddress = self.getParam(data, "SystemAddress")
        self._entryId = self.getParam(data, "EntryID")
        self._name = self.getParam(data, "Name")
        self._nameLocalised = self.getParam(data, "Name_Localised")
        self._subCategory = self.getParam(data, "SubCategory")
        self._subCategoryLocalised = self.getParam(data, "SubCategory_Localised")
        self._category = self.getParam(data, "Category")
        self._categoryLocalised = self.getParam(data, "Category_Localised")
        self._region = self.getParam(data, "Region")
        self._regionLocalised = self.getParam(data, "Region_Localised")
        self._nearestDestination = self.getParam(data, "NearestDestination")
        self._nearestDestinationLocalised = self.getParam(data, "NearestDestination_Localised")
        self._system = self.getParam(data, "System")
        self._latitude = self.getParam(data, "Latitude")
        self._longitude = self.getParam(data, "Longitude")
        self._isNewEntry = self.getParam(data, "IsNewEntry", False)
        self._voucherAmount = self.getParam(data, "VoucherAmount")

    def initFromDatabase(self, data):
        self._systemAddress = data['system_address']
        self._name = data['name']
        self._nameLocalised = data['name_localised']
        self._subCategory = data['subcategory']
        self._category = data['category']
        self._region = data['region']
        self._regionLocalised = data['region_localised']
        self._nearestDestination = data['nearest_destination']
        self._nearestDestinationLocalised = data['nearest_destination_localised']
        self._latitude = data['latitude']
        self._longitude = data['longitude']
        self._isNewEntry = data['is_new_entry']
        self._voucherAmount = data['voucher_amount']

    def getSystemAddress(self):
        return self._systemAddress

    def getEntryID(self):
        return self._entryId

    def getName(self):
        return self._name

    def getNameLocalised(self):
        return self._nameLocalised

    def getSubCategory(self):
        return self._subCategory

    def getSubCategoryLocalised(self):
        return self._subCategoryLocalised

    def getCategory(self):
        return self._category

    def getCategoryLocalised(self):
        return self._categoryLocalised

    def getRegion(self):
        return self._region

    def getRegionLocalised(self):
        return self._regionLocalised

    def getNearestDestination(self):
        return self._nearestDestination

    def getNearestDestinationLocalised(self):
        return self._nearestDestinationLocalised

    def getSystem(self):
        return self._system

    def getLatitude(self):
        return self._latitude

    def getLongitude(self):
        return self._longitude

    def isNewEntry(self):
        return self._isNewEntry

    def getVoucherAmount(self):
        return self._voucherAmount
