from package.Journal.Events.BaseEntity import BaseEntity


class BioData(BaseEntity):
    def __init__(self):
        super().__init__()
        self._genus = None
        self._genusLocalised = None
        self._species = None
        self._speciesLocalised = None
        self._value = None
        self._bonus = None

    def initFromJournal(self, data):
        self._genus = self.getParam(data, "Genus")
        self._genusLocalised = self.getParam(data, "Genus_Localised")
        self._species = self.getParam(data, "Species")
        self._speciesLocalised = self.getParam(data, "Species_Localised")
        self._value = self.getParam(data, "Value")
        self._bonus = self.getParam(data, "Bonus")

    def getGenus(self):
        return self._genus

    def getGenusLocalised(self):
        return self._genusLocalised

    def getSpecies(self):
        return self._species

    def getSpeciesLocalised(self):
        return self._speciesLocalised

    def getValue(self):
        return self._value

    def getBonus(self):
        return self._bonus
